# Guia de Deploy - Sistema de Gerenciamento de Flags

## 📦 Pacote de Deployment Completo

Este pacote contém todos os arquivos necessários para fazer o deploy da aplicação no seu servidor.

## 🚀 Deploy Rápido

### 1. Frontend (public_html)
Copie todos os arquivos da pasta `public_html/` para o diretório público do seu servidor web:

```bash
# Se seu servidor usa public_html/
cp public_html/* /caminho/para/seu/public_html/

# Se seu servidor usa www/ ou htdocs/
cp public_html/* /caminho/para/seu/www/
```

### 2. Backend (Node.js)
```bash
# Upload da pasta backend para seu servidor
cd backend
npm install
```

Configure o arquivo `.env`:
```env
DB_HOST=localhost
DB_USER=seu_usuario_mysql
DB_PASSWORD=sua_senha_mysql
DB_NAME=flag_management
JWT_SECRET=seu_jwt_secret_aqui
PORT=3000
```

Inicie o servidor:
```bash
node server.js
```

### 3. Banco de Dados MySQL
```bash
mysql -u seu_usuario -p < database/schema.sql
```

## ⚙️ Configuração da URL da API

Edite o arquivo `public_html/config.js` e altere conforme necessário:

```javascript
const CONFIG = {
    // Para servidor local
    API_BASE_URL: '/api',
    
    // Para servidor remoto
    // API_BASE_URL: 'https://seu-dominio.com/api',
    
    // Para desenvolvimento
    // API_BASE_URL: 'http://localhost:3000/api',
};
```

## 🔐 Usuários de Teste

- **jose** / password123 (Admin)
- **gabrielpriss** / password123 (Admin)
- **dagoberto** / password123 (Líder)
- **karina** / password123 (Líder)

## ✅ Verificação do Deploy

1. Acesse seu site
2. Faça login com `jose` / `password123`
3. Teste o cadastro de uma flag
4. Verifique os filtros e estatísticas

## 🛠️ Configurações de Servidor

### Apache (.htaccess)
```apache
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule ^(.*)$ index.html [QSA,L]

# Proxy para API
RewriteRule ^api/(.*)$ http://localhost:3000/api/$1 [P,L]
```

### Nginx
```nginx
location / {
    try_files $uri $uri/ /index.html;
}

location /api {
    proxy_pass http://localhost:3000;
    proxy_http_version 1.1;
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection 'upgrade';
    proxy_set_header Host $host;
    proxy_cache_bypass $http_upgrade;
}
```

## 🔧 Solução de Problemas

**Erro de CORS:**
- Verifique se o backend está configurado para aceitar requisições do seu domínio

**Erro 404 nas rotas:**
- Configure o servidor web para redirecionar para index.html

**Erro de conexão com banco:**
- Verifique as credenciais no arquivo `.env`

---

**Status:** ✅ Pronto para Produção  
**Versão:** 1.0.0

