# Sistema de Gerenciamento de Flags Organizacionais

## Visão Geral

Sistema web completo para gerenciamento de flags organizacionais, desenvolvido com foco em usabilidade, responsividade e visual moderno dark. A aplicação permite que líderes e administradores registrem, visualizem e gerenciem ocorrências com colaboradores.

## Tecnologias Utilizadas

- **Front-end**: HTML5, CSS3 (com Tailwind CSS), JavaScript puro
- **Back-end**: Node.js com Express
- **Banco de dados**: MySQL
- **Autenticação**: JWT (JSON Web Tokens)
- **Estilo**: Design moderno dark com modo claro/escuro

## Estrutura do Projeto

```
flag_management_app/
├── frontend/
│   ├── index.html          # Página principal
│   ├── styles.css          # Estilos customizados
│   └── script.js           # JavaScript da aplicação
├── backend/
│   ├── server.js           # Servidor principal
│   ├── config/
│   │   └── database.js     # Configuração do banco
│   ├── middleware/
│   │   └── auth.js         # Middleware de autenticação
│   ├── routes/
│   │   ├── auth.js         # Rotas de autenticação
│   │   ├── users.js        # Rotas de usuários
│   │   ├── employees.js    # Rotas de colaboradores
│   │   ├── flags.js        # Rotas de flags
│   │   └── audit.js        # Rotas de auditoria
│   ├── package.json
│   └── .env                # Variáveis de ambiente
└── database/
    └── schema.sql          # Scripts de criação do banco
```

## Funcionalidades

### Tipos de Usuário

1. **Admin**:
   - Pode cadastrar líderes
   - Possui todas as permissões de um líder
   - Acesso total ao sistema

2. **Líder**:
   - Pode cadastrar flags e colaboradores
   - Vê apenas suas próprias flags no dashboard

### Funcionalidades Principais

- **Dashboard**: Visão geral com estatísticas e flags recentes
- **Gerenciamento de Flags**: CRUD completo com filtros
- **Gerenciamento de Colaboradores**: Cadastro e edição
- **Gerenciamento de Usuários**: Apenas para admins
- **Auditoria**: Log de todas as ações do sistema
- **Modo Escuro/Claro**: Alternância de tema com localStorage

## Usuários Pré-cadastrados

- **José** - Admin (senha: password123)
- **Gabriel Priss** - Admin (senha: password123)
- **Dagoberto** - Líder (senha: password123)
- **Karina** - Líder (senha: password123)

## Instalação e Configuração

### Pré-requisitos

- Node.js (v14 ou superior)
- MySQL (v5.7 ou superior)
- npm ou yarn

### Configuração do Banco de Dados

1. Instale e configure o MySQL
2. Execute o script de criação do banco:

```sql
-- Execute o conteúdo do arquivo database/schema.sql
```

### Configuração do Back-end

1. Navegue até a pasta backend:
```bash
cd backend
```

2. Instale as dependências:
```bash
npm install
```

3. Configure as variáveis de ambiente no arquivo `.env`:
```env
DB_HOST=localhost
DB_USER=root
DB_PASSWORD=
DB_NAME=flag_management
JWT_SECRET=your_jwt_secret_key_here
PORT=3000
```

4. Inicie o servidor:
```bash
npm start
```

### Acesso à Aplicação

- **URL Local**: http://localhost:3000
- **URL Pública**: https://3000-i0knut9uuwlc2ukqr6hhw-3dea8930.manus.computer

## API Endpoints

### Autenticação
- `POST /api/auth/login` - Login do usuário

### Usuários (Admin apenas)
- `GET /api/users` - Listar usuários
- `POST /api/users` - Criar usuário
- `PUT /api/users/:id` - Atualizar usuário
- `DELETE /api/users/:id` - Deletar usuário

### Colaboradores
- `GET /api/employees` - Listar colaboradores
- `POST /api/employees` - Criar colaborador
- `PUT /api/employees/:id` - Atualizar colaborador
- `DELETE /api/employees/:id` - Deletar colaborador

### Flags
- `GET /api/flags` - Listar flags (com filtros)
- `POST /api/flags` - Criar flag
- `PUT /api/flags/:id` - Atualizar flag
- `DELETE /api/flags/:id` - Deletar flag

### Auditoria (Admin apenas)
- `GET /api/audit` - Listar logs de auditoria

## Recursos Visuais

- **Design Moderno**: Interface dark com elementos tecnológicos
- **Responsivo**: Compatível com desktop e mobile
- **Modo Escuro/Claro**: Alternância de tema
- **Animações**: Transições suaves e feedback visual
- **Ícones**: Biblioteca de ícones integrada

## Segurança

- Autenticação JWT
- Controle de acesso baseado em roles
- Validação de dados no front-end e back-end
- Log de auditoria para todas as ações

## Desenvolvimento

### Estrutura do Código

- **Modular**: Código organizado em módulos
- **Comentado**: Comentários explicativos
- **Padrões**: Seguindo boas práticas de desenvolvimento
- **Responsivo**: Design mobile-first

### Próximas Melhorias

- Implementação de notificações em tempo real
- Relatórios avançados
- Integração com sistemas externos
- Backup automático

## Suporte

Para dúvidas ou problemas, consulte a documentação ou entre em contato com a equipe de desenvolvimento.

## Licença

Este projeto é propriedade da organização e está sujeito aos termos de uso internos.

