const express = require('express');
const pool = require('../config/database');
const { authenticateToken, requireAdmin } = require('../middleware/auth');
const router = express.Router();

// Listar logs de auditoria (apenas Admin)
router.get('/', authenticateToken, requireAdmin, async (req, res) => {
    try {
        const { start_date, end_date, user_id, action } = req.query;

        let query = `
            SELECT a.*, u.username 
            FROM audit_logs a 
            LEFT JOIN users u ON a.user_id = u.id
            WHERE 1=1
        `;
        let params = [];

        // Filtros
        if (start_date) {
            query += ' AND DATE(a.timestamp) >= ?';
            params.push(start_date);
        }

        if (end_date) {
            query += ' AND DATE(a.timestamp) <= ?';
            params.push(end_date);
        }

        if (user_id) {
            query += ' AND a.user_id = ?';
            params.push(user_id);
        }

        if (action) {
            query += ' AND a.action LIKE ?';
            params.push(`%${action}%`);
        }

        query += ' ORDER BY a.timestamp DESC LIMIT 1000';

        const [rows] = await pool.execute(query, params);
        res.json(rows);
    } catch (error) {
        console.error('Erro ao buscar logs de auditoria:', error);
        res.status(500).json({ error: 'Erro interno do servidor' });
    }
});

module.exports = router;

